using inetsoftware.Pdfc;
using inetsoftware.Pdfc.Presenter;
using System;

namespace inetsoftware.PdfcSamples
{
    /// <summary>
    /// A simple sample for printing the result of the comparison of 2 PDF Files
    /// Expected 2 arguments, the path of the PDF files
    /// </summary>
    public class SimpleCompareAndPrint
    {
        static SimpleCompareAndPrint()
        {
            // Activate the license once from environment if required.
            string key = Environment.GetEnvironmentVariable("PDFC_KEY");
            if (!string.IsNullOrEmpty(key))
            {
                PDFC.ActivateLicense(key);
            }
        }

        /// <summary>
        /// Start the sample, to show the printing function of the result of comparison between 2 PDF files
        /// </summary>
        /// <param name="args">Expected 2 arguments, the path of the PDF files.</param>
        public static void Main(string[] args)
        {
            if (args == null || args.Length != 2)
            {
                throw new ArgumentException("Usage: <executable> <PDF-File1> <PDF-File2>");
            }

            using (new PDFComparer()
                            .AddPresenter(new DifferencesPrintPresenter(null)) // use the default printer
                            .Compare(args[0], args[1]))
            { }
        }
    }
}